﻿var editWorkFlowItem = {
    context: $(".v-editWorkflowItem"),
    projectId: 0,
    prontoModuleTypeId: -1,
    sampleAssignmentMode: 1,
    isSystemModule: false,
    prontoBlendProjectIdAssociated: 0,
    initialize: function () {
        editWorkFlowItem.projectId = workflowItem.ProjectId;
        editWorkFlowItem.prontoModuleTypeId = workflowItem.ProntoModuleTypeId;
        editWorkFlowItem.sampleAssignmentMode = workflowItem.SampleAssignmentMode;
        editWorkFlowItem.isSystemModule = workflowItem.IsSystemModule;
        if (editWorkFlowItem.isSystemModule) {
            editWorkFlowItem.prontoBlendProjectIdAssociated = workflowItem.ProntoBlendProjectIdAssociated;
        }
        editWorkFlowItem.prontoModuleId = workflowItem.ProntoModuleId;

        $("#ProjectName", editWorkFlowItem.context).a4autocomplete({
            ajaxAction: a4.getAction("GetProjectsForItemAutocomplete", "Home", "Project"),
            ajaxParams: { ignoreProject: $("#HideProjectId").val(), showRoleOnly: $("#ShowRoleOnly").val() },
            valueProperty: "Id",
            labelProperty: "Name",
            categoryProperty: "FolderName",
            altValueField: $("#ProjectId", editWorkFlowItem.context),
            select: function (event, data) {
                var projectId = 0;
                editWorkFlowItem.sampleAssignmentMode = 1;
                editWorkFlowItem.isSystemModule = false;

                editWorkFlowItem.prontoModuleTypeId = -1;
                editWorkFlowItem.prontoBlendProjectIdAssociated = 0;

                $("#ProntoModuleTypeId", editWorkFlowItem.context).val(editWorkFlowItem.prontoModuleTypeId);
                $("#IsSystemModule", editWorkFlowItem.context).val(editWorkFlowItem.isSystemModule);
                $("#ProntoBlendProjectIdAssociated", editWorkFlowItem.context).val(editWorkFlowItem.prontoBlendProjectIdAssociated);

                if (data && data.item) {
                    editWorkFlowItem.sampleAssignmentMode = data.item.SampleAssignmentMode;
                    editWorkFlowItem.isSystemModule = data.item.IsSystemModule;

                    $("#ProntoModuleTypeId", editWorkFlowItem.context).val(editWorkFlowItem.prontoModuleTypeId);
                    $("#IsSystemModule", editWorkFlowItem.context).val(editWorkFlowItem.isSystemModule);
                    projectId = data.item.Id;
                }

                if (projectId != editWorkFlowItem.projectId) {
                    // we need to reset Sample Group  because the value may not be good anymore
                    var sampleGroupDropDown = $(".h-sampleGroup-dropdown", editWorkFlowItem.context);
                    $("option", sampleGroupDropDown).attr("selected", false);
                    $("option[value=0]", sampleGroupDropDown).attr("selected", true);

                    editWorkFlowItem.projectId = projectId;
                    // Reload all module list
                    if (editWorkFlowItem.isSystemModule == true) {
                        editWorkFlowItem.loadProntoModules(projectId, editWorkFlowItem.isSystemModule);
                        editWorkFlowItem.loadCatiModules(projectId, editWorkFlowItem.isSystemModule);
                    }
                    else {
                        editWorkFlowItem.loadCatiModules(projectId, editWorkFlowItem.isSystemModule);
                        editWorkFlowItem.loadProntoModules(projectId, editWorkFlowItem.isSystemModule);
                    }

                    // Disable CATI module, reload and enable it only when the Blend module will be known
                    editWorkFlowItem.setCatiModuleDisable(editWorkFlowItem.isSystemModule == true);

                    $("#SampleAssignmentMode", editWorkFlowItem.context).val(editWorkFlowItem.sampleAssignmentMode);
                    editWorkFlowItem.setGroupDropDownAvailability();
                }
            }
        });

        //
        //  Si le project id existe deja dans la page , c'est que nous voulons modifier une
        //  proriete de l'item ( pronto , cati )
        //
        if ((typeof editWorkFlowItem.projectId == "string" || typeof editWorkFlowItem.projectId == "number") && editWorkFlowItem.projectId != 0) {
            // this is where we are loading the editWorkFlowItem into the dialog and adjust all controls
            if (editWorkFlowItem.isSystemModule) {
                editWorkFlowItem.loadProntoModules(editWorkFlowItem.projectId, editWorkFlowItem.isSystemModule);
                editWorkFlowItem.loadCatiModules(editWorkFlowItem.projectId, editWorkFlowItem.isSystemModule);
            }
            else {
                editWorkFlowItem.loadCatiModules(editWorkFlowItem.projectId, editWorkFlowItem.isSystemModule);
                editWorkFlowItem.loadProntoModules(editWorkFlowItem.projectId, editWorkFlowItem.isSystemModule);

            }
            editWorkFlowItem.setGroupDropDownAvailability();
        }
    },
    //
    //  Chargement du module cati en fonction du project 
    //
    loadCatiModules: function (projectId, IsSystemModule) {
        var autocomplete = $(".h-catiProjectName-autocomplete", editWorkFlowItem.context);

        if (autocomplete.hasClass("autocomplete")) {
            autocomplete.a4autocomplete("enable");
            autocomplete.a4autocomplete("clearValue");
            autocomplete.a4autocomplete("destroy");
        }

        if (projectId && (IsSystemModule == false)) {
            // we load CATI modules with the ProjectId as root call
            autocomplete.a4autocomplete({
                ajaxAction: a4.getAction("GetCatiModulesForItemAutoComplete", "Modules", "Project"),
                ajaxParams: { projectId: projectId },
                valueProperty: "Id",
                labelProperty: "Name",
                altValueField: $("#CatiModuleId", editWorkFlowItem.context),
                select: function (event, data) {
                    editWorkFlowItem.setGroupDropDownAvailability();
                }
            });
            editWorkFlowItem.setCatiModuleDisable(editWorkFlowItem.prontoModuleTypeId === 3);
        }
        else if (projectId && (IsSystemModule == true)) {
            if (editWorkFlowItem.prontoBlendProjectIdAssociated > 0) {
                editWorkFlowItem.setCatiModuleDisable(false);
                // we load CATI modules with the ProntoModueId as root call 
                autocomplete.a4autocomplete({
                    ajaxAction: a4.getAction("GetCatiModulesForItemAutoComplete", "Modules", "Project"),
                    ajaxParams: { projectId: editWorkFlowItem.prontoBlendProjectIdAssociated },
                    valueProperty: "Id",
                    labelProperty: "Name",
                    altValueField: $("#CatiModuleId", editWorkFlowItem.context),
                    select: function (event, data) {
                        editWorkFlowItem.setGroupDropDownAvailability();
                    }
                });
            }
            else { // no blend project Associated
                // we need to disabled it
                editWorkFlowItem.setCatiModuleDisable(true);
            }
        }
        else { // no project id
            editWorkFlowItem.setCatiModuleDisable(false);
        }
    },
    loadProntoModules: function (projectId, IsSystemModule) {
        var autocomplete = $(".h-ProntoModuleName-autocomplete", editWorkFlowItem.context);

        if (autocomplete.hasClass("autocomplete")) {
            autocomplete.a4autocomplete("clearValue");
            autocomplete.a4autocomplete("destroy");
        }

        if (projectId) {
            autocomplete.a4autocomplete({
                ajaxAction: a4.getAction("GetProntoModulesForItemAutoComplete", "Modules", "Project"),
                ajaxParams: { projectId: projectId, isSystemModule: IsSystemModule },
                valueProperty: "Id",
                labelProperty: "Name",
                altValueField: $("#ProntoModuleId", editWorkFlowItem.context),
                defaultValue: "0",
                select: function (event, data) {
                    var moduleId = -1;
                    editWorkFlowItem.prontoModuleId = 0;
                    editWorkFlowItem.prontoModuleTypeId = -1;
                    editWorkFlowItem.prontoBlendProjectIdAssociated = 0;

                    if (data.item) {
                        editWorkFlowItem.prontoModuleId = data.item.prontoModuleId;
                        editWorkFlowItem.prontoModuleTypeId = data.item.ProntoModuleType;
                        editWorkFlowItem.prontoBlendProjectIdAssociated = data.item.BlendProjectIdAssociated;
                    }

                    if (editWorkFlowItem.prontoModuleTypeId === 3) { // 1=pred, 2=non pred, 3=preview, 7=blend
                        // only exist in Preview module type
                        var catiModuleAutocomplete = $(".h-catiProjectName-autocomplete", editWorkFlowItem.context);
                        moduleId = data.item.CatiModuleId;
                        // set the associated CATI when a Preview modul is selected
                        catiModuleAutocomplete.a4autocomplete("setValue", moduleId);

                        editWorkFlowItem.setCatiModuleDisable(true);
                    }
                    else if (editWorkFlowItem.prontoModuleTypeId === 7) {
                        // Blend module type
                        editWorkFlowItem.setCatiModuleDisable(false);
                        editWorkFlowItem.loadCatiModules(projectId, editWorkFlowItem.isSystemModule)
                    }
                    else if (editWorkFlowItem.prontoModuleTypeId === -1) {
                        // Not pronto module type selected
                        if (editWorkFlowItem.isSystemModule) {
                            editWorkFlowItem.loadCatiModules(projectId, editWorkFlowItem.isSystemModule)
                        }
                        editWorkFlowItem.setCatiModuleDisable(editWorkFlowItem.isSystemModule);
                    }
                    else {
                        // Pred, Non-Pred module type
                        editWorkFlowItem.setCatiModuleDisable(false);
                    }

                    // update the hiden value when returning to wokflow dialog
                    $("#ProntoModuleTypeId", editWorkFlowItem.context).val(editWorkFlowItem.prontoModuleTypeId);
                    $("#ProntoBlendProjectIdAssociated", editWorkFlowItem.context).val(editWorkFlowItem.prontoBlendProjectIdAssociated);
                    // update the 
                    editWorkFlowItem.setGroupDropDownAvailability();
                }
            });
        }

        // update the cati drop down visual state
        if (IsSystemModule == false)
            editWorkFlowItem.setCatiModuleDisable(editWorkFlowItem.prontoModuleTypeId === 3);
    },
    setCatiModuleDisable: function (disabled) {
        var catiModuleDropdown = $(".h-catiProjectName-autocomplete", editWorkFlowItem.context);
        if (disabled == true) {
            catiModuleDropdown.addClass("disabled");
        }
        else {
            catiModuleDropdown.removeClass("disabled");
        }
        catiModuleDropdown.prop('readonly', disabled);
    },
    enableSampleGroup: function () {
        var sampleGroupDropDown = $(".h-sampleGroup-dropdown", editWorkFlowItem.context);
        sampleGroupDropDown.removeClass("disabled").prop('disabled', false);

        $("#SampleGroupSaved", editWorkFlowItem.context).val("true");
    },
    disableSampleGroup: function () {
        var sampleGroupDropDown = $(".h-sampleGroup-dropdown", editWorkFlowItem.context);
        sampleGroupDropDown.addClass("disabled").prop('disabled', true);

        // this set the sample group to 0
        $("option", sampleGroupDropDown).attr("selected", false);
        $("option[value=0]", sampleGroupDropDown).attr("selected", true);

        $("#SampleGroupSaved", editWorkFlowItem.context).val("false");
    },
    getFormInput: function () {
        var formInput = {};
        var catiModuleId = $("#CatiModuleId", editWorkFlowItem.context).val();
        var prontoModuleId = $("#ProntoModuleId", editWorkFlowItem.context).val();
        formInput.catiModuleIsSet = false;
        formInput.prontoModuleIsSet = false;

        if (typeof catiModuleId == "string" && catiModuleId != 0) {
            formInput.catiModuleIsSet = true;
        }
        if (typeof prontoModuleId == "string" && prontoModuleId != 0) {
            formInput.prontoModuleIsSet = true;
        }

        return formInput;
    },
    setGroupDropDownAvailability: function () {
        var formInput = editWorkFlowItem.getFormInput();

        if (((!formInput.catiModuleIsSet && !formInput.prontoModuleIsSet) || // both unset mean creation of a new
             (formInput.catiModuleIsSet && !formInput.prontoModuleIsSet) ||
             (formInput.catiModuleIsSet && formInput.prontoModuleIsSet && editWorkFlowItem.prontoModuleTypeId == 3)) &&  // 3 mean preview
            (editWorkFlowItem.sampleAssignmentMode != 2)) { // 1=Group ; 2=Role //
            editWorkFlowItem.enableSampleGroup();
        }
        else {
            editWorkFlowItem.disableSampleGroup();
        }
    }
};

$(document).ready(function () {
    if (editWorkFlowItem.context.length > 0) {
        editWorkFlowItem.initialize();

        a4.parent().workflowItemData = {
            workflowItem: workflowItem,
            saved: saved
        };
    }
});